program PlatformaIzolacyjna4;

uses
  SysUtils,
  DUnitX.TestFramework,
  DUnitX.Loggers.Console,
  DUnitX.Windows.Console,
  Delphi.Mocks in 'Delphi.Mocks.pas',
  Delphi.Mocks.Behavior in 'Delphi.Mocks.Behavior.pas',
  Delphi.Mocks.Helpers in 'Delphi.Mocks.Helpers.pas',
  Delphi.Mocks.Interfaces in 'Delphi.Mocks.Interfaces.pas',
  Delphi.Mocks.MethodData in 'Delphi.Mocks.MethodData.pas',
  Delphi.Mocks.Utils in 'Delphi.Mocks.Utils.pas',
  Delphi.Mocks.VirtualInterface in 'Delphi.Mocks.VirtualInterface.pas',
  Delphi.Mocks.When in 'Delphi.Mocks.When.pas',
  Delphi.Mocks.Expectation in 'Delphi.Mocks.Expectation.pas',
  Delphi.Mocks.ObjectProxy in 'Delphi.Mocks.ObjectProxy.pas',
  Delphi.Mocks.Proxy in 'Delphi.Mocks.Proxy.pas',
  Delphi.Mocks.VirtualMethodInterceptor in 'Delphi.Mocks.VirtualMethodInterceptor.pas',
  Delphi.Mocks.ReturnTypePatch in 'Delphi.Mocks.pas',
  uZalenoZgaszajcaWyjtek in 'uZalenoZgaszajcaWyjtek.pas';

type
  [TestFixture]
  TTestProcesoraWidetw = class
     public
     [Test]
     procedure TestWyjtkuZyWidet;
  end;

procedure TTestProcesoraWidetw.TestWyjtkuZyWidet;
var
  TestowanaKlasa: IProcesorWidetw;
  ImitowanyWidet: TMock<IWidet>;
begin
  // Przygotuj
  ImitowanyWidet := TMock<IWidet>.Create;
  ImitowanyWidet.Setup.WillRaise(EWyjtekZyWidet).When.Dobry;
  TestowanaKlasa := TProcesorWidetw.Create;
  // Wykonaj
  TestowanaKlasa.PrzetwarzajWidet(ImitowanyWidet);
  // Sprawd
  ImitowanyWidet.Verify();
end;

var
  Runner: ITestRunner;
  Logger: ITestLogger;
  Results: IRunResults;

begin
  TDUnitX.RegisterTestFixture(TTestProcesoraWidetw);
  try
    // Utworzenie zmiennej testowej
    Runner := TDUnitX.CreateRunner;
    Runner.UseRTTI := True;
    // Wskazanie sposobu rejestrowania wynikw testw
    Logger := TDUnitXConsoleLogger.Create;
    Runner.AddLogger(Logger);
    // Wykonanie testw
    Results := Runner.Execute;
    System.Write('Koniec. Nacinij <Enter> aby zakoczy.');
    System.Readln;
  except
    on E: Exception do
      System.Writeln(E.ClassName, ': ', E.Message);
  end;

end.